
; Define RC5 address of Remote Control

;RemoteAddr	EQU	0x06
RemoteAddr	EQU	0x00	;URC22B, Cod: 0026

; Definition of Keys and key-codes on my remote control

NUM_0	EQU	0x00
NUM_1	EQU	0x01
NUM_2	EQU	0x02
NUM_3	EQU	0x03
NUM_4	EQU	0x04
NUM_5	EQU	0x05
NUM_6	EQU	0x06
NUM_7	EQU	0x07
NUM_8	EQU	0x08
NUM_9	EQU	0x09
NUM_10	EQU	0x0A	;10/0
ASTRSK 	EQU	0x0B	;CH.PIC
STANDBY	EQU	0x0C	;StandBy
MUTE	EQU	0x0D	;Mute
NUM_E	EQU 0x0E	;->.<-
TEXT	EQU	0x0F	;->|_|
VOL_UP	EQU	0x10	;Vol+
VOL_DN	EQU	0x11	;Vol-
BRI_UP	EQU	0x12	;Color+
BRI_DN	EQU	0x13	;Color-
SAT_UP	EQU	0x14	;Bri+
SAT_DN	EQU	0x15	;Bri-
BAL_RI	EQU	0x1A	;Cont+
BAL_LE	EQU	0x1B	;Cont-
CON_UP	EQU	0x20	;CH+
CON_DN	EQU	0x21	;CH-
HUE_DN	EQU	0x22	;<<
EXIT	EQU	0x24	;Memo
ADJUST	EQU	0x26	;Pr <>
ENTER	EQU	0x28	;2/12
FREEZE	EQU	0x29	;|_|
PHA_UP	EQU	0x2A	;|>
PHA_DN	EQU	0x2B	; >
SHA_UP	EQU	0x2C	;REC
SHA_DN	EQU	0x2D	;Eject
;HELP	EQU	0x2F
HUE_UP	EQU	0x38	;>>
F2		EQU	0x32	;G / Yellow Btn
F1		EQU	0x34	;H / Blue Btn
F3		EQU	0x35	;<|
F4		EQU	0x36	;F / Green Btn
F5		EQU	0x37	;E / Red Btn
PAUSE	EQU	0x3C	;Pause
ADDR	EQU	0x3F	;TV/Sat
;CUR_UP	EQU	0x50
;CUR_DN	EQU	0x51
;CUR_LE	EQU	0x55
;CUR_RI	EQU	0x56


; Definition of Functions on the Propeller clock

SEC_UP		EQU	VOL_UP
SEC_DN		EQU	VOL_DN
MIN_UP		EQU	BAL_RI
MIN_DN		EQU	BAL_LE
HOUR_UP		EQU	CON_UP
HOUR_DN		EQU	CON_DN
DAY_UP		EQU	BRI_UP
DAY_DN		EQU	BRI_DN
WDAY_UP		EQU	SHA_UP
MON_UP		EQU	SAT_UP
MON_DN		EQU	SAT_DN
YEAR_UP		EQU	HUE_UP
YEAR_DN		EQU	HUE_DN
INDEX_UP	EQU	PHA_UP
INDEX_DN	EQU	PHA_DN

BlueLine	EQU	F1
DigiTime	EQU	F2
DigiDate	EQU	F3
AnaTime		EQU	F4
TTicks		EQU	F5

DemoM		EQU	ASTRSK	;Demo Mode
TextMode	EQU	TEXT
TSecMode 	EQU	MUTE
;j parancsok
TRotation  	EQU ENTER
TStaticText	EQU FREEZE
;j parancsok
TWDay		EQU	EXIT
WDAY_DN 	EQU	SHA_DN
SEC_CL		EQU	NUM_0
SET_SP		EQU	ADDR
